<?php
// Funkcja zwracajca liczb wszystkich sw uytych w cigu.
function full_count_words($str) {
    // Wykorzystanie funkcji str_word_count z parametrem '1' w celu uzyskania listy sw.
    $words = str_word_count($str, 1);
    
    // Przetwarzanie w ptli elementw tej tablicy w celu utworzenia nowej tablicy
    // z indeksami w postaci sw oraz liczb wystpie poszczeglnych sw w tekcie.
    $results = array();
    foreach ($words as $w) {
        // Konwersja caego sowa na mae litery.
        // Dziki temu sowa  'Ten' i 'ten' bd rwnowane.
        $lw = strtolower($w);
        // Przy pierwszym wystpieniu okrelonego sowa
        //  dodajemy je do tablicy, w innym przypadku zwikszamy licznik.
        if (!(isset($results[$lw]))) {
            $results[$lw] = 1;
        } else {
            $results[$lw]++;
        }
    }
    
    // Po wykonaniu ptli mamy potrzebne liczniki, zatem moemy je zwrci.
    return $results;
}

$test_string = "Ze wzgldu na to, e wachlarz zada obejmujcych przetwarzanie cigw znakw jest bardzo szeroki, w tym rozdziale omwiono wikszo funkcji przetwarzania cigw znakw oglnego przeznaczenia. Bardziej specjalistyczne zagadnienia, na przykad kodowanie znakw w dokumentach HTML, zaprezentowano w innych rozdziaach.";

// Obliczenie licznikw wystpie poszczeglnych sw:
$wordcount = full_count_words($test_string);

// Wywietlenie liczby wystpie sowa >>znakw<<:
// Sowo >>znakw<< wystpio 3 razy.
echo '<pre>';
echo "Sowo >>znakw<< wystpio {$wordcount['znakw']} razy.\n\n";

// Wywietlenie licznikw dla wszystkich sw:
print_r($wordcount);
echo '</pre>';
?>
